/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.logd;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.servlet.logd.ExpanderData;
import com.ibm.hwmca.fw.servlet.logd.GetDisplayerName;
import com.ibm.hwmca.fw.servlet.logd.GetExpanderData;
import com.ibm.hwmca.fw.servlet.logd.HexExpander;
import com.ibm.hwmca.fw.servlet.logd.IssueCmd;
import com.ibm.hwmca.fw.servlet.logd.TextExpander;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;

public class DllExpander {
    private static final String TRACE_MASKT = "XLDSDLLT";
    private static final String TRACE_MASKD = "XLDSDLLD";
    private static final String TRACE_MASKF = "XLDSDLLF";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogdServ");
    private static final String DLL_MAP_FILE = "LogServletClassDllMap.properties";
    private static final String RECORD_OPTION = "recordOption";
    private static final String FILE_FLAGS = "flags";
    private static final String EXE_CMD = "iqyyxpdk";
    private Map _map;

    public DllExpander(Map map) throws IOException {
        this._map = map;
        this.dllExpander();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void dllExpander() throws IOException {
        block31: {
            Trace.trace(TRACE_MASKT, "-> DllExpander.dllExpander()");
            String tmpFileName = null;
            File tmpFile = null;
            FileOutputStream fos = null;
            String logClassStr = null;
            String logTypeStr = null;
            String logBlockIdStr = null;
            Trace.trace(TRACE_MASKF, "DllExpander - doing InitialRequest");
            ExpanderData expanderData = GetExpanderData.getData(this._map);
            if (expanderData.getDataExists()) {
                PrintWriter out = expanderData.getResponse().getWriter();
                byte[] hexData = expanderData.getHexData();
                Trace.trace(TRACE_MASKF, "get data for the dll expander ");
                Log log = expanderData.getLog();
                LogBlock logBlock = expanderData.getLogBlock();
                byte logClass = log.getLogClass();
                logClassStr = HexString.toHex(logClass, true).toUpperCase();
                byte logType = log.getLogType();
                logTypeStr = HexString.toHex(logType, true).toUpperCase();
                byte block = logBlock.getBlockId();
                logBlockIdStr = HexString.toHex(block, true).toUpperCase();
                String displayerName = null;
                String entryPoint = null;
                String name = GetDisplayerName.getDisplayerName(DLL_MAP_FILE, logClassStr, logTypeStr, logBlockIdStr, "dllServExp: ");
                if (name == null || name.length() == 0) {
                    Trace.trace(TRACE_MASKF, "dllExpName/EntryPoint returned is null");
                } else {
                    Trace.trace(TRACE_MASKF, "dllExpName/EntryPoint=" + name);
                    int len = name.length();
                    boolean cont = true;
                    for (int i = 0; i < len && cont; ++i) {
                        if (!Character.isWhitespace(name.charAt(i))) continue;
                        displayerName = name.substring(0, i);
                        ++i;
                        while (i < len && cont) {
                            if (!Character.isWhitespace(name.charAt(i))) {
                                entryPoint = name.substring(i);
                                cont = false;
                            }
                            ++i;
                        }
                    }
                }
                if (displayerName == null || displayerName.length() == 0 || entryPoint == null || entryPoint.length() == 0) {
                    Trace.trace(TRACE_MASKF, "Couldn't retrieve the dll or entry point, thus, use hex displayer");
                    HexExpander hexE = new HexExpander(this._map);
                } else {
                    Trace.trace(TRACE_MASKF, "dllExpName=" + displayerName + " entryPoint=" + entryPoint);
                    boolean continueProcessing = true;
                    try {
                        File directory = new File(BaseFileControl.getFilePath("tmp"));
                        tmpFile = File.createTempFile("LogExpander", ".trm", directory);
                        tmpFileName = tmpFile.getAbsolutePath();
                        Trace.trace(TRACE_MASKF, "tmp dllDatafile Name =[" + tmpFileName + "]");
                        fos = new FileOutputStream(tmpFile);
                        fos.write(hexData);
                        fos.close();
                        fos = null;
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "unable to create/writeData to tmp file, thus, use hex displayer");
                        Trace.trace(TRACE_MASKF, e);
                        continueProcessing = false;
                        HexExpander hexE = new HexExpander(this._map);
                    }
                    short recordOption = 0;
                    short fileFlag = 0;
                    if (continueProcessing) {
                        HexExpander hexE;
                        String cmd = null;
                        try {
                            recordOption = this.getShortField(log, RECORD_OPTION);
                            fileFlag = this.getShortField(log, FILE_FLAGS);
                        }
                        catch (Exception ex) {
                            Trace.trace(TRACE_MASKF, "Error retrieving private log data");
                            Trace.trace(TRACE_MASKF, ex);
                            continueProcessing = false;
                            hexE = new HexExpander(this._map);
                        }
                        if (continueProcessing) {
                            try {
                                LogBlock[] logBlocks = log.getLogBlocks();
                                Date date = log.getTimestamp();
                                long time = date.getTime();
                                Trace.trace(TRACE_MASKF, "milliSec=" + time + " hexDataLen=" + hexData.length);
                                String eventName = log.getEventName();
                                if (eventName == null || eventName.length() == 0) {
                                    eventName = " ";
                                }
                                Trace.trace(TRACE_MASKF, "befEventName=[" + eventName + "]");
                                int eventNameLen = eventName.length();
                                StringBuffer eventNameBuf = new StringBuffer(eventNameLen);
                                for (int i = 0; i < eventNameLen; ++i) {
                                    if (eventName.charAt(i) == ' ') {
                                        eventNameBuf.append('0');
                                        continue;
                                    }
                                    eventNameBuf.append('1');
                                }
                                eventName = eventName.replace(' ', '.');
                                Trace.trace(TRACE_MASKF, "aftEventName=[" + eventName + "]");
                                cmd = "iqyyxpdk " + displayerName + " " + entryPoint + " " + "!" + tmpFileName + " " + HexString.toHex(tmpFile.length()) + " " + HexString.toHex(logBlocks.length) + " " + HexString.toHex(recordOption) + " " + HexString.toHex(logClass, true) + "  " + HexString.toHex(logType, true) + " " + HexString.toHex(log.getUser()) + " " + HexString.toHex(time / 1000L) + " " + HexString.toHex(time % 1000L / 10L) + " " + HexString.toHex(fileFlag) + " " + HexString.toHex(block, true) + " " + eventName + " " + eventNameBuf;
                                Trace.trace(TRACE_MASKF, "EXE cmd=" + cmd);
                                String str = IssueCmd.exeString(cmd);
                                if (str == null || str.length() == 0) {
                                    Trace.trace(TRACE_MASKF, "No data in the expander processed string.  Use hex displayer");
                                    continueProcessing = false;
                                    HexExpander hexE2 = new HexExpander(this._map);
                                } else {
                                    Trace.trace(TRACE_MASKF, "String len of expander data is=" + str.length());
                                    TextExpander textExpander = new TextExpander(out, str);
                                }
                            }
                            catch (IOException ioe) {
                                Trace.trace(TRACE_MASKF, "unable to issue exe=iqyyxpdk use hex displayer");
                                Trace.trace(TRACE_MASKF, ioe);
                                hexE = new HexExpander(this._map);
                                continueProcessing = false;
                            }
                        }
                    }
                    Object var32_40 = null;
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException ioe) {
                        Trace.trace(TRACE_MASKF, "Error closing dll expander's tmp file stream.");
                        Trace.trace(TRACE_MASKF, ioe);
                    }
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                }
                break block31;
                catch (Throwable throwable) {
                    Object var32_41 = null;
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException ioe) {
                        Trace.trace(TRACE_MASKF, "Error closing dll expander's tmp file stream.");
                        Trace.trace(TRACE_MASKF, ioe);
                    }
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                    throw throwable;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- DllExpander.service()");
    }

    private short getShortField(Log log, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Trace.trace(TRACE_MASKF, "->  getField() for ", fieldName);
        Class<?> logClass = log.getClass();
        Field field = logClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        short data = field.getShort(log);
        Trace.trace(TRACE_MASKF, "<-  getField() " + fieldName + "=" + HexString.toHex(data));
        return data;
    }
}

